<?php
require '../backnd/regback.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Management</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f7f6;
            margin: 0;
            padding: 0;
        }

        .container {
            background-color: #ffffff;
            border-radius: 8px;
            padding: 40px;
            margin: 20px auto;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.1);
            max-width: 900px;
            width: 90%;
        }

        h2 {
            text-align: center;
            font-size: 32px;
            margin-bottom: 25px;
            color: #333;
        }

        .input-group {
            margin-bottom: 20px;
            display: flex;
            flex-direction: column;
        }

        .input-group label {
            font-size: 16px;
            color: #555;
            margin-bottom: 5px;
        }

        .input-group input {
            padding: 12px;
            font-size: 18px;
            border: 1px solid #ddd;
            border-radius: 5px;
            width: 100%;
            outline: none;
            transition: border-color 0.3s ease;
        }

        .input-group input:focus {
            border-color: #27ae60;
        }

        .btn {
            width: 100%;
            padding: 12px;
            background-color: #27ae60;
            color: #fff;
            border: none;
            border-radius: 5px;
            font-size: 18px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            margin-top: 15px;
        }

        .btn:hover {
            background-color: #229954;
        }

        .error, .success {
            text-align: center;
            font-size: 16px;
            margin-top: 10px;
        }

        .error {
            color: #e74c3c;
        }

        .success {
            color: #2ecc71;
        }

        table {
            width: 100%;
            margin-top: 20px;
            border-collapse: collapse;
        }

        table th, table td {
            padding: 15px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }

        table th {
            background-color: #2ecc71;
            color: white;
            text-align: center;
        }

        table td {
            background-color: #f9f9f9;
            text-align: center;
        }

        table tr:hover {
            background-color: #f1f1f1;
        }

        .actions {
            display: flex;
            gap: 10px;
            justify-content: center;
        }

        .btn-update, .btn-delete {
            background-color: #3498db;
            padding: 8px 20px;
            border-radius: 5px;
            color: #fff;
            font-size: 14px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .btn-update:hover {
            background-color: #2980b9;
        }

        .btn-delete {
            background-color: #e74c3c;
        }

        .btn-delete:hover {
            background-color: #c0392b;
        }

        .table-container {
            max-width: 900px;
            margin: 0 auto;
        }
    </style>
</head>
<body>

    <!-- Registration Form -->
    <div class="container">
        <h2>Create an Account</h2>

        <?php if (isset($error)): ?>
            <p class="error"><?= $error; ?></p>
        <?php elseif (isset($success)): ?>
            <p class="success"><?= $success; ?></p>
        <?php endif; ?>

        <form action="" method="POST">
            <div class="input-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" placeholder="Enter your email" required>
            </div>
            <div class="input-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" placeholder="Enter your password" required>
            </div>
            <button type="submit" name="register" class="btn">Register</button>
        </form>
    </div>

    <!-- Admin List Table -->
    <div class="container">
        <h2>Admin List</h2>

        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Email</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($admins->num_rows > 0): ?>
                        <?php while ($row = $admins->fetch_assoc()): ?>
                            <tr>
                                <td><?= $row['id']; ?></td>
                                <td><?= $row['email']; ?></td>
                                <td class="actions">
                                    <form action="" method="POST">
                                        <input type="hidden" name="admin_id" value="<?= $row['id']; ?>">
                                        <input type="password" name="new_password" placeholder="New Password" required>
                                        <button type="submit" name="update_password" class="btn-update">Update</button>
                                    </form>
                                    <form action="" method="POST">
                                        <input type="hidden" name="admin_id" value="<?= $row['id']; ?>">
                                        <button type="submit" name="delete_admin" class="btn-delete">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="3">No admins found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</body>
</html>
